<?php defined('SYSPATH') or die('No direct script access.');

class Model_User_Query extends ORM
{
    
	protected $_primary_key = 'id';
	protected $_table_name = 'users_queries';
	protected $_table_columns = array(
		'id' => NULL,
		'name' => NULL,
		'user_id' => NULL,
        'host' => NULL,
        'host_strong' => ['type' => 'bool'],
        'net' => NULL,
        'length' => NULL,
        'referrer' => NULL,
        'link' => NULL,
        'link_strong' => ['type' => 'bool'],
        'date_start' => NULL,
        'date_end' => NULL,
        'ip' => NULL,
        'version' => NULL,
	);
    
    protected $_has_many = [
        /* DEPRECATED */
        'items' => [
            'model' => 'Filter_Regex',
        ],
    ];
    
    protected $errors;
    
    public function getErrors()
    {
        return $this->errors;
    }

    public function addOrUpdateQuery(array $post, $user_id = null)
    {
        // Get
        $data = Arr::extract($post, [
            'name',
            'host',
            'host_strong',
            'net',
            'length',
            'referrer',
            'link',
            'link_strong',
            'ip',
            'date_start',
            'date_end',
            'version',
        ]);
        
        // Filter
        $data['host'] = implode('|', array_filter((array)Arr::get($data, 'host')));
        $data['host_strong'] = Arr::get($data, 'host_strong', '0');
        $data['net'] = implode('|', array_filter((array)Arr::get($data, 'net')));
        $data['length'] = '' != Arr::get($post, 'length') ? $post['length'] : null;
        $data['referrer'] = implode('|', array_filter((array)Arr::get($data, 'referrer')));
        $data['link'] = implode('|', array_filter((array)Arr::get($data, 'link')));
        $data['link_strong'] = Arr::get($data, 'link_strong', '0');
        $data['ip'] = implode('|', array_filter((array)Arr::get($data, 'ip')));
        $data['date_start'] = '' != Arr::get($post, 'date_start') ? $post['date_start'] : null;
        $data['date_end'] = '' != Arr::get($post, 'date_end') ? $post['date_end'] : null;
        $data['version'] = '' != Arr::get($post, 'version') ? $post['version'] : null;

        // Validate
        $validation = Validation::factory($data)
            ->label('name', 'Name')
            ->rule('name', 'not_empty')
            ->label('host', 'Host')
            ->label('host_strong', 'Host Strong?')
            ->label('net', 'Net')
            ->label('length', 'Length')
            ->rule('length', 'digit')
            ->label('referrer', 'Referrer')
            ->label('link', 'Link')
            ->label('link_strong', 'Link Strong?')
            ->label('ip', 'IP address mask')
            ->label('date_start', 'Date start')
            ->label('date_end', 'Date end')
            ->label('version', 'Version');

        if ( ! $validation->check() )
        {
            $this->errors = $validation->errors('validation');
            
            return false;
        }
        
        // Upsert
        Database::instance()->begin();
        $user_query = ORM::factory(substr(get_class(), strlen('Model_')), $this->id);
        if ( ! $user_query->loaded() )
        {
            $user_query->user_id = $user_id;
        }
        $user_query->name = $data['name'];
        $user_query->host = $data['host'];
        $user_query->host_strong = $data['host_strong'];
        $user_query->net = $data['net'];
        $user_query->length = $data['length'];
        $user_query->referrer = $data['referrer'];
        $user_query->link = $data['link'];
        $user_query->link_strong = $data['link_strong'];
        $user_query->ip = $data['ip'];
        $user_query->date_start = $data['date_start'];
        $user_query->date_end = $data['date_end'];
        $user_query->version = $data['version'];
        try
        {
            $user_query->save();
            Database::instance()->commit();
        }
        catch(Exception $e)
        {
            Database::instance()->rollback();
            Kohana::$log->add(Log::ERROR, Kohana_Exception::text($e), null, ['exception' => $e]);
            $this->errors[] = 'Unexcepted technical error';
            
            return false;
        }
        
        return $user_query;
    }
    
    public function countData()
    {
        return count(array_merge(array_filter(explode('|', $this->host)), array_filter(explode('|', $this->net)), array_filter(explode('|', $this->referrer)), array_filter(explode('|', $this->link)))) + (null !== $this->length) + (null !== $this->date_start) + (null !== $this->date_end);
    }
    
    public function getAsPost()
    {
        $post = $this->as_array();
        $post['user_query'] = $post['id'];
        unset($post['id']);
        unset($post['name']);
        unset($post['user_id']);
        
        return $post;
    }
    
}

